/*
 * Socket routines
 */

#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "fms.h"

/*
 * Open our incoming socket and start listening on it
 */
int
open_socket(
  int port)
{
  int s;
  int rc;
  int one = 1;
  struct sockaddr_in my_addr;

  /* open the socket we will listen on */
  s = socket(AF_INET, SOCK_STREAM, 0);
  if (s == -1) goto init_sock_fail;

  /* set up our address and port */
  memset(&my_addr, 0, sizeof(my_addr));
  my_addr.sin_family = AF_INET;
  my_addr.sin_addr.s_addr = (in_addr_t) htonl(INADDR_ANY);
  my_addr.sin_port = htons(port);

  /* set options for the socket */
  rc = setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &one, sizeof(one));
  if (rc == -1) goto init_sock_fail;
  rc = setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, &one, sizeof(one));
  if (rc == -1) goto init_sock_fail;
  
  /* bind the socket to this address */
  rc = bind(s, (const struct sockaddr *)&my_addr, sizeof(my_addr));
  if (rc == -1) goto init_sock_fail;

  /* Initiate listening on the socket */
  rc = listen(s, 10);
  if (rc == -1) goto init_sock_fail;

  return s;

 init_sock_fail:
  if (s != -1) close(s);
  return -1;
}

/*
 * Accept a new connection and set appropriate options
 */
int
new_connection(
  int s,
  void **who)
{
  int rc;
  int one = 1;
  struct sockaddr_in *addr;
  int ns;
  unsigned int len;

  addr = NULL;
  ns = -1;
  
  /* create a place to hold the address */
  len = sizeof(struct sockaddr_in);
  addr = (struct sockaddr_in *) calloc(1, len);
  if (addr == NULL) goto new_fail;

  /* create the new socket */
  ns = accept(s, (struct sockaddr *)addr, &len);
  if (ns == -1) goto new_fail;

  /* set its options */
  rc = setsockopt(ns, SOL_SOCKET, SO_KEEPALIVE, &one, sizeof(one));
  if (rc == -1) goto new_fail;

  /* return socket and address of connector */
  *who = (void *)addr;
  return ns;

 new_fail:
  if (ns != -1) close(ns);
  if (addr != NULL) free(addr);
  return -1;
}
